package gov.va.med.mhv.getcare.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.model.HealthCareProvider;

import org.springframework.stereotype.Component;

@Component
public class HealthCareProviderConverter {

	
	public static HealthCareProviderDTO convertHealthCareProviderDomain(HealthCareProvider hcpEntity) {
		HealthCareProviderDTO dto = new HealthCareProviderDTO();
		dto.setUserProfileId(hcpEntity.getUserProfileId());
		dto.setHealthCareProviderId(hcpEntity.getHealthCareProviderId());
		dto.setEmailAddress(hcpEntity.getEmailAddress());
		dto.setFirstName(hcpEntity.getFirstName());
		dto.setLastName(hcpEntity.getLastName());
		dto.setOtherClinician(hcpEntity.getOtherClinician());
		dto.setProviderType(hcpEntity.getProviderType());
		dto.setWorkPhone(hcpEntity.getWorkPhone());
		dto.setWorkPhoneExt(hcpEntity.getWorkPhoneExt());
		dto.setComments(hcpEntity.getComments());
		return dto;
	}

	
	public static HealthCareProvider convertHealthCareProviderDTO(HealthCareProviderDTO dto) {
		HealthCareProvider hcpEntity = new HealthCareProvider();
		hcpEntity.setUserProfileId(dto.getUserProfileId());
		hcpEntity.setHealthCareProviderId(dto.getHealthCareProviderId());
		hcpEntity.setEmailAddress(dto.getEmailAddress());
		hcpEntity.setFirstName(dto.getFirstName());
		hcpEntity.setLastName(dto.getLastName());
		hcpEntity.setOtherClinician(dto.getOtherClinician());
		hcpEntity.setProviderType(dto.getProviderType());
		hcpEntity.setWorkPhone(dto.getWorkPhone());
		hcpEntity.setWorkPhoneExt(dto.getWorkPhoneExt());
		hcpEntity.setComments(dto.getComments());
		hcpEntity.setOplock(0);
		return hcpEntity;
	}
	
	
	public static List<HealthCareProviderDTO>  convertHealthCareProviders( List<HealthCareProvider> providers ){
		List<HealthCareProviderDTO> dtos = new ArrayList<HealthCareProviderDTO>();
		for(HealthCareProvider provider : providers){
			HealthCareProviderDTO dto = convertHealthCareProviderDomain(provider);
			dtos.add(dto);
		}
		return dtos;
	}
}
